CREATE OR REPLACE FUNCTION sim2_act_field_set_id(p_tsrfdact_is_number IN NUMBER,
                                                 p_tsrfdact_org_id    IN VARCHAR2) RETURN VARCHAR2 IS 
  v_fs_id VARCHAR2(2000);

  CURSOR fs_id_cur(p_tsrfdact_is_number IN NUMBER,
                   p_tsrfdact_org_id    IN CHAR) IS
    SELECT f.id_code
    FROM   tsrfdset f,
           tsrfafsa a
    WHERE  f.tsrfdset_is_number = a.tsrfdset_is_number
    AND    f.tsrfdset_org_id    = a.tsrfdset_org_id
    AND    a.tsrfdact_is_number = p_tsrfdact_is_number
    AND    a.tsrfdact_org_id    = p_tsrfdact_org_id;

BEGIN NULL;
  FOR fs_id_rec IN fs_id_cur(p_tsrfdact_is_number, p_tsrfdact_org_id) LOOP
    IF v_fs_id IS NULL THEN
      v_fs_id := fs_id_rec.id_code;
    ELSE
      v_fs_id := v_fs_id||'\'||fs_id_rec.id_code;
    END IF;
  END LOOP;
  
  RETURN v_fs_id;
END sim2_act_field_set_id;
/

